/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.app;

import DE.siemens.ad.logo.app.MDIManager;
import DE.siemens.ad.logo.app.MDIMenuManager;
import DE.siemens.ad.logo.app.MenuManager;
import DE.siemens.ad.logo.app.Model;
import DE.siemens.ad.logo.app.ModelFileListener;
import DE.siemens.ad.logo.app.TabbedPaneMenuManager;
import DE.siemens.ad.logo.app.View;
import DE.siemens.ad.logo.app.action.ActionFactory;
import DE.siemens.ad.logo.app.action.ActionManager;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.pdraw.app.LogoComfort;
import DE.siemens.ad.pdraw.simulation.NetworkSimulationManager;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import DE.siemens.ad.pdraw.standard.LogoDrawingView;
import DE.siemens.ad.pdraw.util.LogoComfortStatusLine;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TabbedPaneMDIManager
extends MDIManager
implements ModelFileListener,
ChangeListener {
    protected JTabbedPane fTabbedPane;
    public ActionFactory fActionFactory;
    protected ActionManager fActionManager;
    protected Hashtable fTabViewDictionary;
    public MDIMenuManager fMenuManager;
    private WindowListener fWindowHandler;

    public void addView(View view) {
        JPanel viewContainer = new JPanel(new BorderLayout());
        viewContainer.add(view.getViewComponent());
        this.fTabViewDictionary.put(viewContainer, view);
        this.fTabbedPane.addTab(this.getTabName(view), view.getEditor().getEditorInfo().getIcon(), viewContainer, view.getModel().getFile().getPath());
        int tabIndex = this.fTabbedPane.indexOfComponent(viewContainer);
        this.fTabbedPane.setForegroundAt(tabIndex, view.getModel().isModified() ? Color.red : Color.black);
        view.getModel().addModelFileListener(this);
        super.addView(view);
    }

    public void changeToView(View view) {
        super.changeToView(view);
        if (view == null || view == this.fActiveTopLevelView) {
            return;
        }
        JComponent tabComponent = this.getTabComponent(view);
        if (this.fTabbedPane.getSelectedComponent() != tabComponent) {
            this.fTabbedPane.removeChangeListener(this);
            this.fTabbedPane.setSelectedComponent(tabComponent);
            this.fTabbedPane.addChangeListener(this);
        }
        this.fApplicationSurface.setEditor(view.getEditor());
        this.fActiveTopLevelView = view;
    }

    public void close() {
        super.close();
    }

    public ActionFactory getActionFactory() {
        if (this.fActionFactory == null) {
            this.fActionFactory = new ActionFactory(this);
            this.fActionFactory.setActionPackage("DE.siemens.ad.logo.app.action.");
        }
        return this.fActionFactory;
    }

    public ActionManager getActionManager() {
        if (this.fActionManager == null) {
            this.fActionManager = new ActionManager(this);
        }
        return this.fActionManager;
    }

    public View getActiveView() {
        return (View)this.fTabViewDictionary.get(this.fTabbedPane.getSelectedComponent());
    }

    public JComponent getMDIComponent(View view) {
        if (view == null) {
            JPanel backgroundPanel = new JPanel();
            backgroundPanel.setBackground(Global.BACKGROUND_COLOR_APP);
            return backgroundPanel;
        }
        return this.fTabbedPane;
    }

    public MenuManager getMenuManager() {
        if (this.fMenuManager == null) {
            this.fMenuManager = new TabbedPaneMenuManager(this);
        }
        return this.fMenuManager;
    }

    public String getName() {
        return Language.getString("mdiManager.tabbedPane.name", "File card");
    }

    public JComponent getPreviewPanel() {
        JTabbedPane tabbedPane = new JTabbedPane();
        String window = Language.getString("mdiManager.window", "Window");
        JPanel panel1 = new JPanel();
        panel1.setBackground(Global.BACKGROUND_COLOR);
        tabbedPane.add(window + "1", panel1);
        JPanel panel2 = new JPanel();
        panel2.setBackground(Global.BACKGROUND_COLOR);
        tabbedPane.add(window + "2", panel2);
        return tabbedPane;
    }

    public JComponent getTabComponent(View view) {
        Enumeration e = this.fTabViewDictionary.keys();
        Object key = null;
        Object value = null;
        while (e.hasMoreElements()) {
            key = e.nextElement();
            value = this.fTabViewDictionary.get(key);
            if (!((View)value).getModel().equals(view.getModel())) continue;
            return key;
        }
        return null;
    }

    protected String getTabName(View view) {
        return view.getModel().getFile().getName();
    }

    public void modelFileChanged(Model model, File oldFile, File newFile) {
        View v2 = null;
        for (View v2 : this.getViews(model)) {
            int tabIndex = this.fTabbedPane.indexOfComponent(this.getTabComponent(v2));
            this.fTabbedPane.setTitleAt(tabIndex, this.getTabName(v2));
            this.fTabbedPane.setToolTipTextAt(tabIndex, model.getFile().getPath());
        }
    }

    public void open() {
        this.fTabViewDictionary = new Hashtable(20);
        this.fTabbedPane = new JTabbedPane();
        this.fTabbedPane.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    int tabIndex = TabbedPaneMDIManager.this.fTabbedPane.indexAtLocation(e.getX(), e.getY());
                    if (tabIndex == -1) {
                        return;
                    }
                    Component tabComponent = TabbedPaneMDIManager.this.fTabbedPane.getComponentAt(tabIndex);
                    View view = (View)TabbedPaneMDIManager.this.fTabViewDictionary.get(tabComponent);
                    JPopupMenu popupMenu = view.getEditor().getMenuManager().getPopupMenu(TabbedPaneMDIManager.this);
                    popupMenu.show(TabbedPaneMDIManager.this.fTabbedPane, e.getX(), e.getY());
                }
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }
        });
        this.fTabbedPane.addChangeListener(this);
        super.open();
    }

    protected WindowListener getWindowEventHandler() {
        if (this.fWindowHandler == null) {
            this.fWindowHandler = new WindowHandler();
        }
        return this.fWindowHandler;
    }

    public void removeView(View view) {
        Component selectedComponent;
        super.removeView(view);
        JComponent viewContainer = this.getTabComponent(view);
        this.fTabbedPane.remove(viewContainer);
        this.fTabViewDictionary.remove(viewContainer);
        if (this.getViews().isEmpty()) {
            this.fApplicationSurface.setEditor(null);
        }
        if ((selectedComponent = this.fTabbedPane.getSelectedComponent()) != null) {
            View selectedView = (View)this.fTabViewDictionary.get(selectedComponent);
            this.changeToView(selectedView);
        }
        view.getModel().removeModelFileListener(this);
    }

    public void replaceTopLevelView(View oldView, View newView) {
        if (this.fActiveTopLevelView == oldView) {
            this.fActiveTopLevelView = newView;
        }
        JComponent tabComponent = this.getTabComponent(oldView);
        this.fTabViewDictionary.remove(tabComponent);
        this.fTabViewDictionary.put(tabComponent, newView);
        this.fViews.remove(oldView);
        this.fViews.add(newView);
    }

    public void setMenuManager(MDIMenuManager newMenuManager) {
        this.fMenuManager = newMenuManager;
    }

    public void stateChanged(ChangeEvent e) {
        Component selectedComponent = this.fTabbedPane.getSelectedComponent();
        if (selectedComponent == null) {
            return;
        }
        View view = (View)this.fTabViewDictionary.get(selectedComponent);
        this.changeToView(view);
    }

    public void modelFileSavedStatusChanged(Model model, boolean oldStatus, boolean newStatus) {
        Color tabColor = newStatus ? Color.red : Color.black;
        View v2 = null;
        for (View v2 : this.getViews(model)) {
            if (v2.getModel() == model) {
                int tabIndex = this.fTabbedPane.indexOfComponent(this.getTabComponent(v2));
                this.fTabbedPane.setForegroundAt(tabIndex, tabColor);
                break;
            }
            if (!(v2.getEditor() instanceof LogoComfort)) continue;
            ((LogoComfortStatusLine)((LogoComfort)v2.getEditor()).getStatusLine()).setModified(true);
        }
    }

    public void updateSimulatedViewTitle(View view) {
        String ip = ((LogoDrawing)((LogoDrawingView)view).drawing()).getWiringDiagram().getNetworkInfo().getIPAddress();
        int tabIndex = this.fTabbedPane.indexOfComponent(this.getTabComponent(view));
        if (tabIndex < 0) {
            return;
        }
        if (NetworkSimulationManager.getInstance().getSimulationManager(ip) != null) {
            this.fTabbedPane.setTitleAt(tabIndex, "<html>" + view.getModel().getFile().getName() + "<br>" + ip + "</html>");
            this.fTabbedPane.setIconAt(tabIndex, Global.getIcon("Network.gif"));
        } else {
            this.fTabbedPane.setTitleAt(tabIndex, view.getModel().getFile().getName());
            this.fTabbedPane.setIconAt(tabIndex, Global.getIcon("Simulation.gif"));
        }
    }

    public void updateViewTitle(File oldFileInView, File newFileInView) {
        for (View view : this.getViews()) {
            if (!oldFileInView.getPath().equalsIgnoreCase(view.getModel().getFile().getPath())) continue;
            int tabIndex = this.fTabbedPane.indexOfComponent(this.getTabComponent(view));
            if (tabIndex >= 0) {
                view.getModel().setFile(newFileInView);
                String newTitle = this.fTabbedPane.getTitleAt(tabIndex).replace(oldFileInView.getName(), newFileInView.getName());
                this.fTabbedPane.setTitleAt(tabIndex, newTitle);
            }
            return;
        }
    }

    protected class WindowHandler
    implements WindowListener {
        protected WindowHandler() {
        }

        public void windowActivated(WindowEvent e) {
        }

        public void windowClosed(WindowEvent e) {
            TabbedPaneMDIManager.this.getApplication().exit(false);
        }

        public void windowClosing(WindowEvent e) {
            TabbedPaneMDIManager.this.fApplication.exit(false);
        }

        public void windowDeactivated(WindowEvent e) {
        }

        public void windowDeiconified(WindowEvent e) {
        }

        public void windowIconified(WindowEvent e) {
        }

        public void windowOpened(WindowEvent e) {
        }
    }
}

